"use strict";

var selectScopeElem = document.getElementById("selScope");
var scopeimageElem = document.getElementById("scopeimage");
var freezeScope = document.getElementById("chkfreeze");
var aspectRatio = document.getElementById("chkaspectratio");
var audiometers = document.getElementById("chkAudioMeters");
var nCurrentScope = 0;
var lastscopeupdate = 0;
var nLastUpdate = 0;
var jpegsize = 0;
var l_xmlHttpScopeJpeg = getHTTPObject();
var l_xmlHttpScopeJpegMs = getHTTPObject();
var l_xmlHttpSelectScope = getHTTPObject();
var l_xmlHttpStatus = getHTTPObject();
var singleShotTimer = null;
var fMetersEnabled = true;
var fDisplayEnabled = true;

window.onload = () => {
    let scopeSelector = document.getElementById("selScope");
    var opt = document.createElement('option');
    opt.value = 0;
    opt.innerHTML = "All";
    scopeSelector.appendChild(opt);

    for (let index = 1; index <= 6; index++) {
        indexToScopeName(index, scopeName => {
            var opt = document.createElement('option');
            opt.value = index;
            opt.innerHTML = index + " - " + scopeName;
            scopeSelector.appendChild(opt);
        });
    }
    selectScopeElem.selectedIndex = 0;
}


function onChangeFreeze() {
    nLastUpdate = 0;
    setTimeout(function () { getScopeJpeg() }, 5);
}

// Get XML data regarding the current jpeg timing
function getScopeJpegLastMs() {
    if (freezeScope && freezeScope.checked == true) {
        return;
    }
    var szRequest = "VVWXMLMediaCmd?getvalue&cmdalt=previewframe&position=1" + "&speed=" + nCurrentScope + "&flags=" + 294912 + "&preview&garbage=" + (new Date()).getTime();
    // Stop the current request if it's still waiting
    l_xmlHttpScopeJpegMs.abort();
    // Open a connection to the server
    l_xmlHttpScopeJpegMs.open("GET", szRequest);
    // Setup a function for the server to run when it's done
    l_xmlHttpScopeJpegMs.onreadystatechange = updatePreviewMs;
    // Send the request
    l_xmlHttpScopeJpegMs.send(null);
}

function updatePreviewMs() {
    if (l_xmlHttpScopeJpegMs.readyState == 4) {
        // A complete response has been received
        var xmlobject = l_xmlHttpScopeJpegMs.responseXML;
        if (xmlobject == null) {
            xmlobject = parseXml(l_xmlHttpScopeJpegMs.responseText);
            if (xmlobject == null) {
                xmlobject = parseXml(l_xmlHttpScopeJpegMs.response);
            }
        }
        // Get MediaCmd
        if (xmlobject != null) {
            var mCmd = xmlobject.getElementsByTagName("MediaCmd");
            if (mCmd[0] != null) {
                //got it				
                jpegsize = parseInt(mCmd[0].getElementsByTagName("Speed")[0].getAttribute("Value"), 10);
                var newupdatems = parseInt(mCmd[0].getElementsByTagName("Position")[0].getAttribute("Value"), 10);
                if (lastscopeupdate != newupdatems || newupdatems == 0) {
                    lastscopeupdate = newupdatems;
                    setTimeout(function () { getScopeJpeg() }, 10);
                } else {
                    setTimeout(function () { getScopeJpegLastMs() }, 10);
                }
            }
        }
    }
}

// Get XML data regarding the current state
function getScopeJpeg() {
    if (freezeScope && freezeScope.checked == true) {
        return;
    }
    var szRequest = "VVWXMLMediaCmd?getvalue&cmdalt=previewframe&position=1&speed=" + nCurrentScope + "&flags=" + 32800 + "&VideoChannels=" + jpegsize + "&preview&garbage=" + (new Date()).getTime();
    // Stop the current request if it's still waiting
    l_xmlHttpScopeJpeg.abort();
    // Open a connection to the server
    l_xmlHttpScopeJpeg.open("GET", szRequest);
    // Setup a function for the server to run when it's done
    l_xmlHttpScopeJpeg.onreadystatechange = updatePreviewFrame;
    // Send the request
    l_xmlHttpScopeJpeg.send(null);
}

function updatePreviewFrame() {
    if (l_xmlHttpScopeJpeg.readyState == 4) {
        // A complete response has been received
        var xmlobject = l_xmlHttpScopeJpeg.responseXML;
        if (xmlobject == null) {
            xmlobject = parseXml(l_xmlHttpScopeJpeg.responseText);
            if (xmlobject == null) {
                xmlobject = parseXml(l_xmlHttpScopeJpeg.response);
            }
        }
        // Get MediaCmd
        if (xmlobject != null) {
            var mCmd = xmlobject.getElementsByTagName("MediaCmd");
            if (mCmd[0] != null) {
                // Ascii
                var frameText = mCmd[0].getElementsByTagName("arbID")[0];
                if (frameText != null) {
                    var height = parseInt(mCmd[0].getElementsByTagName("End")[0].getAttribute("Value"), 10);
                    var width = parseInt(mCmd[0].getElementsByTagName("Start")[0].getAttribute("Value"), 10);
                    var size = parseInt(mCmd[0].getElementsByTagName("Speed")[0].getAttribute("Value"), 10);
                    var audiometerwidth = 225;
                    if (audiometers && audiometers.checked == false) {
                        audiometerwidth = 0;
                    }
                    if (width && height && (aspectRatio && aspectRatio.checked == true)) {
                        var maxHeight = document.documentElement.clientHeight * 0.92;
                        var maxWidth = document.documentElement.clientWidth;
                        if (!isItMobile() && document.documentElement.clientWidth > audiometerwidth) {
                            maxWidth -= audiometerwidth;
                        }
                        if ((maxHeight / height) > (maxWidth / width)) {
                            scopeimageElem.width = maxWidth;
                            scopeimageElem.height = (maxWidth / width) * height;
                        } else {
                            scopeimageElem.height = maxHeight;
                            scopeimageElem.width = (maxHeight / height) * width;
                        }
                    } else {
                        if (!isItMobile() && document.documentElement.clientWidth > audiometerwidth) {
                            // Leave room for the meters
                            scopeimageElem.width = document.documentElement.clientWidth - audiometerwidth;
                        } else {
                            scopeimageElem.width = document.documentElement.clientWidth;
                        }
                        scopeimageElem.height = document.documentElement.clientHeight * 0.92;
                        if (isItMobile()) {
                            scopeimageElem.height = scopeimageElem.height / 2;
                        }
                    }
                    var frameLen = frameText.getAttribute("length");
                    // String - to byte
                    var jpegData = getInnerText(frameText);
                    if (jpegData) {
                        scopeimageElem.src = 'data:image/jpeg;base64,' + jpegData;
                        setTimeout(function () { getScopeJpegLastMs() }, 10);
                        nLastUpdate = Date.now();
                    }
                }

            }
        }
    }
}

function selectScope() {
    nCurrentScope = selectScopeElem.options[selectScopeElem.selectedIndex].value;
    // Get new size
    var szRequest = "VVWXMLMediaCmd?getvalue&cmdalt=previewframe&position=1&speed=" + nCurrentScope + "&flags=32768" + "&preview";
    // Stop the current request if it's still waiting
    l_xmlHttpSelectScope.abort();
    // Open a connection to the server
    l_xmlHttpSelectScope.open("GET", szRequest);
    // Setup a function for the server to run when it's done
    l_xmlHttpSelectScope.onreadystatechange = null;
    // Send the request
    l_xmlHttpSelectScope.send(null);

    lastscopeupdate = 0;
    setTimeout(function () { getScopeJpeg() }, 5);
    setTimeout(function () { getScopeJpegLastMs() }, 25);
}

var timeoutWatchdog = setInterval(
    function () {
        var now = Date.now();
        if ((now - nLastUpdate) > 5000) {
            nLastUpdate = now;
            setTimeout(function () { getScopeJpeg() }, 5);
            setTimeout(function () { getScopeJpegLastMs() }, 25);
        }
    }, 1000);

setTimeout(function () { getScopeJpegLastMs() }, 10);
