const defaultscopeValue = 0;
const picturescopeValue = 1;
const picturescopeName = "picturescope";
const vectorscopeValue = 2;
const vectorscopeName = "vectorscope";
const waveformscopeValue = 3;
const waveformscopeName = "waveformscope";
const waveformrgbscopeValue = 4;
const waveformrgbscopeName = "waveformrgbscope";
const histogramscopeValue = 6;
const histogramscopeName = "histogramscope";
const chromaticityscopeValue = 7;
const chromaticityscopeName = "chromaticityscope";
const statusscopeValue = 12;
const statusscopeName = "statusscope";

const ancscopeValue = 18;
const ancscopeName = "ancscope";
const timingscopeValue = 17;
const timingscopeName = "timingscope";
const audiovectorscopeValue = 130;
const audiovectorscopeName = "audiovectorscope";
const audiophasescopeValue = 131;
const audiophasescopeName = "audiophasescope";
const audiohistogramscopeValue = 132;
const audiohistogramscopeName = "audiohistogramscope";
const audiowavescopeValue = 262144;
const audiowavescopeName = "audiowavescope";
const audiometerscopeValue = 19;
const audiometerscopeName = "audiometerscope";
const audiometerssurroundscopeValue = 20;
const audiometerssurroundscopeName = "audiometerssurroundscope";
const audiometersloudnessscopeValue = 21;
const audiometersloudnessscopeName = "audiometersloudnessscope";

function scopeValueToName(scopeValue) {
    var scopeName = "";
    //Get scope name

    if (scopeValue == picturescopeValue || scopeValue == defaultscopeValue) {
        scopeName = picturescopeName;
    }
    else if (scopeValue == vectorscopeValue) {
        scopeName = vectorscopeName;
    }
    else if (scopeValue == waveformscopeValue) {
        scopeName = waveformscopeName;
    }
    else if (scopeValue == waveformrgbscopeValue) {
        scopeName = waveformrgbscopeName;
    }
    else if (scopeValue == histogramscopeValue) {
        scopeName = histogramscopeName;
    }
    else if (scopeValue == chromaticityscopeValue) {
        scopeName = chromaticityscopeName;
    }
    else if (scopeValue == statusscopeValue) {
        scopeName = statusscopeName;
    }
    else if (scopeValue == ancscopeValue) {
        scopeName = ancscopeName;
    }
    else if (scopeValue == timingscopeValue) {
        scopeName = timingscopeName;
    }
    else if (scopeValue == audiovectorscopeValue) {
        scopeName = audiovectorscopeName;
    }
    else if (scopeValue == audiophasescopeValue) {
        scopeName = audiophasescopeName;
    }
    else if (scopeValue == audiohistogramscopeValue) {
        scopeName = audiohistogramscopeName;
    }
    else if (scopeValue == 254) {
        scopeName = picturescopeName;
    }
    else if (scopeValue == audiowavescopeValue) {
        scopeName = audiowavescopeName;
    }
    else if (scopeValue == audiometerscopeValue) {
        scopeName = audiometerscopeName;
    }
    else if (scopeValue == audiometerssurroundscopeValue) {
        scopeName = audiometerssurroundscopeName;
    }
    else if (scopeValue == audiometersloudnessscopeValue) {
        scopeName = audiometersloudnessscopeName;
    }

    return scopeName;
}

function scopeNameToDivName(scopeName) {
    var divName = "";
    switch (scopeName) {
        case picturescopeName:
            divName = "div-picture";
            break;
        case vectorscopeName:
            divName = "div-vector";
            break;
        case waveformscopeName:
            divName = "div-waveform";
            break;
        case waveformrgbscopeName:
            divName = "div-waveform-rgb";
            break;
        case histogramscopeName:
            divName = "div-histo";
            break;
        case chromaticityscopeName:
            divName = "div-chroma";
            break;
        case statusscopeName:
            divName = "div-status";
            break;
        case ancscopeName:
            divName = "div-anc";
            break;
        case timingscopeName:
            divName = "div-timing";
            break;
        case audiovectorscopeName:
            divName = "div-audio-vector";
            break;
        case audiophasescopeName:
            divName = "div-audio-phase";
            break;
        case audiohistogramscopeName:
            divName = "div-audio-histogram";
            break;
        case audiowavescopeName:
            divName = "div-audio-wave";
            break;
        case audiometerscopeName:
            divName = "div-audio-meter";
            break;
        case audiometerssurroundscopeName:
            divName = "div-audio-metersurround";
            break;
        case audiometersloudnessscopeName:
            divName = "div-audio-meterloudness";
            break;
    }

    return divName;
}

function indexToScopeName(index, callback) {
    var x = (index - 1) % 3;
    var y = Math.floor((index - 1) / 3);

    var httpCmd = "drasticcmd?getscope=&x=" + x + "&y=" + y + "&key=getScopes";
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function (data) {
        if (xhr.readyState === 4 && xhr.status === 200) {
            //Value of scope name
            var obj = JSON.parse(xhr.responseText);
            let scopeName = scopeValueToName(obj.value);
            callback(scopeName)
        }
    }.bind(this);
    xhr.send();
}

function setScopeClear() {
    var pictureDiv = document.getElementById("div-picture");
    var vectorDiv = document.getElementById("div-vector");
    var waveformDiv = document.getElementById("div-waveform");
    var waveformRgbDiv = document.getElementById("div-waveform-rgb");
    var histoDiv = document.getElementById("div-histo");
    var chromaDiv = document.getElementById("div-chroma");
    var statusDiv = document.getElementById("div-status");
    var ancDiv = document.getElementById("div-anc");
    var timingDiv = document.getElementById("div-timing");
    var audioVectorDiv = document.getElementById("div-audio-vector");
    var audioPhaseDiv = document.getElementById("div-audio-phase");
    var audioHistoDiv = document.getElementById("div-audio-histogram");
    var audioWaveDiv = document.getElementById("div-audio-wave");
    var audioMeterDiv = document.getElementById("div-audio-meter");
    var audioMetersSurroundDiv = document.getElementById("div-audio-metersurround");
    var audioMetersLoudnessDiv = document.getElementById("div-audio-meterloudness");

    /*if (!pageRefresh) {*/
    pictureDiv.style.display = "none";
    vectorDiv.style.display = "none";
    waveformDiv.style.display = "none";
    waveformRgbDiv.style.display = "none";
    histoDiv.style.display = "none";
    chromaDiv.style.display = "none";
    statusDiv.style.display = "none";
    ancDiv.style.display = "none";
    timingDiv.style.display = "none";
    audioVectorDiv.style.display = "none";
    audioPhaseDiv.style.display = "none";
    audioHistoDiv.style.display = "none";
    audioWaveDiv.style.display = "none";
    audioMeterDiv.style.display = "none";
    audioMetersSurroundDiv.style.display = "none";
    audioMetersLoudnessDiv.style.display = "none";
    /*}*/
}

function getSetting(x, y, key, callback) {
    var httpCmd = "drasticcmd?getsetting=&x=" + x + "&y=" + y + "&key=" + key;

    nCurX = x;
    nCurY = y;
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function (data) {
        if (xhr.readyState === 4 && xhr.status === 200) {
            // Get nameOfBool from key= elem of xhr.responseURL
            var obj = JSON.parse(xhr.responseText);
            callback(obj.value);
        }
    }.bind(this);
    xhr.send();
}

function setConfigSettings(scopeName, xCoordinate, yCoordinate) {
    var divName = scopeNameToDivName(scopeName);
    var divElement = document.getElementById(divName);
    let checkBoxes = divElement.querySelectorAll("input.checkboxInput.setting-item");
    checkBoxes.forEach(checkbox => {
        getSetting(xCoordinate, yCoordinate, checkbox.id, (value) => { checkbox.checked = value; });
    });

    let dropdowns = divElement.querySelectorAll(".setting-item > select");
    dropdowns.forEach(dropdown => {
        getSetting(xCoordinate, yCoordinate, dropdown.id, (value) => { dropdown.value = value; });
    });
}

function onClickButton(buttonId) {
    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=" + buttonId;
    var xhr = getHTTPObject();
    // Send command
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}

function onClickBool(formCheckBox) {
    // Get the id of the checkbox
    var checkboxId = formCheckBox.id;
    var splitString = checkboxId.split('_');
    var checkboxMainId = splitString[0];
    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=" + checkboxMainId;
    var xhr = getHTTPObject();
    // Build the command string
    if (checkboxId === "black_chroma") {
        if (formCheckBox.checked) {
            httpCmd += "&value=0";
        } else {
            httpCmd += "&value=1";
        }
    } else {
        if (formCheckBox.checked) {
            httpCmd += "&value=1";
        } else {
            httpCmd += "&value=0";
        }
    }
    // Send command
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function (nameOfBool) {
        if (xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}