/** Drastic MediaCMD for HTML helper file

*/

/* jshint ignore:start */
// ********************
const vvwiFileName = 0;
const vvwiNativeLocator = 1;
const vvwiUniversalName = 2;
const vvwiIP = 3;
const vvwiSourceLocator = 4;

const vvwiChannel = 5;
const vvwiChannelName = 6;
const vvwiChannelDescription = 7;
const vvwiTitle = 8;
const vvwiSubject = 9;
const vvwiCategory = 10;			// <-- 10
const vvwiKeywords = 11;
const vvwiRatings = 12;
const vvwiComments = 13;
const vvwiOwner = 14;
const vvwiEditor = 15;
const vvwiSupplier = 16;
const vvwiSource = 17;
const vvwiProject = 18;
const vvwiStatus = 19;
const vvwiAuthor = 20;				// <-- 20
const vvwiRevisionNumber = 21;
const vvwiProduced = 22;
const vvwiAlbum = 23;
const vvwiArtist = 24;
const vvwiComposer = 25;
const vvwiCopyright = 26;
const vvwiCreationData = 27;
const vvwiDescription = 28;
const vvwiDirector = 29;
const vvwiDisclaimer = 30;			// <-- 30
const vvwiEncodedBy = 31;
const vvwiFullName = 32;
const vvwiGenre = 33;
const vvwiHostComputer = 34;
const vvwiInformation = 35;
const vvwiMake = 36;
const vvwiModel = 37;
const vvwiOriginalArtist = 38;
const vvwiOriginalFormat = 39;
const vvwiPerformers = 40;			// <-- 40
const vvwiProducer = 41;
const vvwiProduct = 42;
const vvwiSoftware = 43;
const vvwiSpecialPlaybackRequirements = 44;
const vvwiTrack = 45;
const vvwiWarning = 46;
const vvwiURLLink = 47;
const vvwiEditData1 = 48;
const vvwiEditData2 = 49;
const vvwiEditData3 = 50;			// <-- 50
const vvwiEditData4 = 51;
const vvwiEditData5 = 52;
const vvwiEditData6 = 53;
const vvwiEditData7 = 54;
const vvwiEditData8 = 55;
const vvwiEditData9 = 56;
const vvwiVersionString = 57;
const vvwiManufacturer = 58;
const vvwiLanguage = 59;
const vvwiFormat = 60;				// <-- 60
const vvwiInputDevice = 61;
const vvwiDeviceModelNum = 62;
const vvwiDeviceSerialNum = 63;
const vvwiReel = 64;
const vvwiShot = 65;
const vvwiTake = 66;
const vvwiSlateInfo = 67;
const vvwiFrameAttribute = 68;
const vvwiEpisode = 69;
const vvwiScene = 70;				// <-- 70
const vvwiDailyRoll = 71;
const vvwiCamRoll = 72;
const vvwiSoundRoll = 73;
const vvwiLabRoll = 74;
const vvwiKeyNumberPrefix = 75;
const vvwiInkNumberPrefix = 76;
const vvwiPictureIcon = 77;
const vvwiProxyFile = 78;
const vvwiCustomMetadataBlockPointer = 79;
const vvwiImageInfo = 80;
const vvwiUMID = 81;
const vvwiEND_OF_STRINGS = 82;
	
const vvwiNumericStart = 4096;//0x1000,
const vvwiTimeCode = 4097;
const vvwiUserBits = 4098;
const vvwiVITCTimeCode = 4099;
const vvwiVITCUserBits = 4100;
const vvwiVITCLine3 = 4101;
const vvwiPosterFrame = 4102;
const vvwiAFrame = 4103;
const vvwiAspectRatio = 4104;
const vvwiOriginalRate = 4105;
const vvwiOriginalScale = 4106;   //
const vvwiConversions = 4107;
const vvwiVersionNumber = 4108;
const vvwiFileSize = 4109;
const vvwiFileDate = 4110;
const vvwiFileTime = 4111;
const vvwiSequenceNumber = 4112;
const vvwiTotalStreams = 4113;
const vvwiTotalLength = 4114;
const vvwiFilmManufacturerCode = 4115;
const vvwiFilmTypeCode = 4116;       //
const vvwiWhitePoint = 4117;
const vvwiBlackPoint = 4118;
const vvwiBlackGain = 4119;
const vvwiBreakPoint = 4120;
const vvwiGamma1000 = 4121;
const vvwiTagNumber = 4122;
const vvwiFlags = 4123;
const vvwiTimeCodeType = 4124;
const vvwiLTCTimeCodeType = 4125;
const vvwiVITCTimeCodeType = 4126;   //
const vvwiProdDate = 4127;
const vvwiUniqueID = 4128;
const vvwiCustomMetadataBlockType = 4129;
const vvwiCustomMetadataBlockSize = 4130;
const vvwiNorthSouthEastWest = 4131;
const vvwiLatitude = 4132;
const vvwiLongitude = 4133;
const vvwiExposure = 4134;
const vvwiRedGain = 4135;
const vvwiBlueGain = 4136;           //
const vvwiWhiteBalance = 4137;
const vvwiMatrix = 4138;
const vvwiGreenGain = 4139;
/*
const vvwiVideoWidth = 65536;//0x10000,
const vvwiVideoHeight,
const vvwiVideoPlanes,
const vvwiVideoBitCount,
const vvwiVideoCompression,
const vvwiVideoSizeImage,
const vvwiVideoXPelsPerMeter,
const vvwiVideoYPelsPerMeter,
const vvwiVideoClrUsed,
const vvwiVideoClrImportant,
const vvwiVideoReserved,
const vvwiVideoFccType,
const vvwiVideoFccHandler,
const vvwiVideoFlags,
const vvwiVideoCaps,
const vvwiVideoPriority,
const vvwiVideoLanguage,
const vvwiVideoScale,
const vvwiVideoRate,
const vvwiVideoStart,
const vvwiVideoLength,
const vvwiVideoInitialFrames,
const vvwiVideoSuggestedBufferSize,
const vvwiVideoQuality,
const vvwiVideoSampleSize,
const vvwiVideoEditCount,
const vvwiVideoFormatChangeCount,
const vvwiVideoPitch,
const vvwiVideoDrFlags,
const vvwiVideoFileType,
const vvwiVideoResDrastic,
const vvwiAudioType,
const vvwiAudioChannels,
const vvwiAudioFrequency,
const vvwiAudioBits,
const vvwiLastElementPlus1
	// DO NOT ADD ANYTHING BELOW vvwiLastElementPlus1
*/
/* jshint ignore:end */

// ********************
// ****************
// *** AJAX Obj ***
// ****************

// Create an HttpObject
function getHTTPObject() 
{ 
	var xmlhttp; 
   
	/*@cc_on 
		@if (@_jscript_version >= 5) 
			try 
			{ 
				xmlhttp = new ActiveXObject("Msxml2.XMLHTTP"); 
			}catch (e) 
			{ 
				try 
				{ 
					xmlhttp = new ActiveXObject("Microsoft.XMLHTTP"); 
				} catch (E) 
				{ 
					xmlhttp = false; 
				} 
			} 
		@else 
			xmlhttp = false; 
		@end @*/  
   
	if (!xmlhttp && typeof XMLHttpRequest !== undefined) 
	{ 
		try 
		{ 
			xmlhttp = new XMLHttpRequest(); 
		} catch (e) 
		{ 
			xmlhttp = false; 
		} 
	} 
	return xmlhttp;     
} 

var g_xmlHttp = getHTTPObject(); // Create the HTTP Object
var g_xmlHttpMs = getHTTPObject(); // Create the Last Change Ms HTTP Object
var g_xmlHttpVvwCmd = getHTTPObject(); // Create the VvwCmdHTTP Object  

// Need to deal with dsync lChannel
var g_xmlStateObject = new Array();

// ****************
// ****************

// ******************
// *** Text Tools ***
// ******************

// Convert a XML string to an XML object
if (window.DOMParser) {
	parseXml = function(xmlStr) {
		return ( new window.DOMParser() ).parseFromString(xmlStr, "text/xml");
	}
} else if (typeof window.ActiveXObject != "undefined" && new window.ActiveXObject("Microsoft.XMLDOM")) {
	parseXml = function(xmlStr) {
		var xmlDoc = new window.ActiveXObject("Microsoft.XMLDOM");
		xmlDoc.async = "false";
		xmlDoc.loadXML(xmlStr);
		return xmlDoc;
	};
} else {
	parseXml = function() { 
		return null; 
	}
}

// Trim any blank spaces from the end of the string
function rightTrim(sString)
{
	if(sString)
	{
		while (sString.substring(sString.length-1, sString.length) == ' ')
		{
			sString = sString.substring(0,sString.length-1);
		}
	}
	return sString;
}

// Trim slashes from the end of a string	
function rightTrimSlash(sString)
{
	if(sString)
	{
		while (sString.substring(sString.length-1, sString.length) == '\\')
		{
			sString = sString.substring(0,sString.length-1);
		}
	}
	return sString;
}


// Verify if we have a standard Extension
function hasStdExt(sString)
{
	if(sString)
	{
		if(sString.length > 4)
		{
			if(sString.substring(sString.length-3, sString.length-4) == '.')
			{
				// Dot is in the proper location for a standard extension
				return true;
			}
		}
	}
	return false;	
}

// Verify if contains a dot for an extension
function hasAnyExt(sString)
{
	var i;
	if(sString)
	{
		if(sString.length > 5)
		{
			for (i = sString.length-1; i>0; i = i - 1) 
			{
				if(sString.substring(i,i+1) == ".")
				{
					// Dot is present indicating an extension
					return true;
				}
			}			
		}
	}
	return false;	
}


// Covert # to %23	
function verifyChars(sString)
{
	//var lSlashCount = 0;
	/*
	for (var i = 0; i < sString.length-1; i++) 
	{
		if(sString.substring(i, i+1) == '#')
		{
			//lSlashCount ++;
			//if(lSlashCount == 2)
			//{
			//	return sString.substring(0,i-1);
			//}
			
			sString.replace("#","%23");
		}
	}	
	*/
	return sString.replace("#","%23");
}

function trimEnd(sString)
{
	var lSlashCount = 0, i;
	
	for (i = sString.length-1; i>0; i = i - 1) 
	{
		if(sString.substring(i-1, i) == '\\')
		{
			lSlashCount = lSlashCount + 1;
			if(lSlashCount == 2)
			{
				return sString.substring(0,i-1);
			}
		}
	}	
	return sString;
}
	
// Convert backslashes to forward slashes
function toForwardSlashes(sString)
{
	var szNewString = "", i;
	if(sString)
	{
		
		for (i = 0; i < sString.length; i = i + 1) 
		{
			if(sString.substring(i,i+1) == "\\")
			{
				szNewString += "/";
			}
			else
			{
				szNewString += sString.substring(i,i+1);
			}
		}
	}
	return szNewString;
}

// Check is characters are all valid
function areCharsValid(sString)
{
	var i;
	if(sString)
	{
		// Accept only ascii 0-127
		
		for (i = 0; i < sString.length; i = i + 1) 
		{
			if(sString.charCodeAt(i) > 127)
			{
				//alert("Invlaid Charactor " + sString.charCodeAt(i) + " " + sString.charAt(i));
				return false;
			}
		}
		return true;
	}
	return true;
}



// Get text value from a node for IE or Firefox/Mozilla
function getInnerText (node) 
{
	var szText = '', i;
	if(node === null || typeof node === undefined)
	{
		szText = null;
	} else if (typeof node.textContent !== undefined) 
	{
		szText = node.textContent;
	} else if (typeof node.innerText !== undefined) 
	{
		szText = node.innerText;
	} else if (typeof node.text !== undefined) 
	{
		szText = node.text;
	} else {
		switch (node.nodeType) 
		{
			case 3:
			case 4:
				szText = node.nodeValue;
				break;
			case 1:
			case 11:
				for (i = 0; i < node.childNodes.length; i = i + 1) 
				{
					szText += getInnerText(node.childNodes[i]);
				}
				break;
			default:
				szText = "";
				break;
		}
	}
	return szText;
}

function getBase(sString)
{
	if(sString)	
	{
		if(sString.substring(sString.length-3, sString.length) == '\\..')
		{
			sString = sString.substring(0,sString.length-3);
		}
	}
	return sString;
}
// ****************
// ****************

// *******************
// *** Other Tools ***
// *******************

var hD="0123456789ABCDEF";

function d2h(d) 
{
	var h = hD.substr(d&15,1);
	while(d>15) 
	{
		d>>=4;
		h=hD.substr(d&15,1)+h;
	}
	
	if(h.length < 8)
	{
		if(h.length == 1)
		{
			h = "0x0000000" + h;
		}
		else if(h.length == 2)
		{
			h = "0x000000" + h;
		}
		else if(h.length == 3)
		{
			h = "0x00000" + h;
		}
		else if(h.length == 4)
		{
			h = "0x0000" + h;
		}
		else if(h.length == 5)
		{
			h = "0x000" + h;
		}
		else if(h.length == 6)
		{
			h = "0x00" + h;
		}
		else if(h.length == 7)
		{
			
		}		
	}
	else
	{
		h = "0x" + h;
	}
		
	return h;
}

function h2d(h) 
{
	return parseInt(h,16);
}

function tc2Sec(szTC) 
{ 
	var i;
	if(szTC.length != 8)
	{
		return "error";
	}
	
	var valReturn = 0;
	var valSixDigits = "";
	var szCharacter = "";

	//for (var i = 0; i < szTC.length-3; i++) 
	for (i = 0; i < szTC.length; i++) 
	{
		szCharacter = szTC.substring(i,i+1);
		if(szCharacter >= "0" && szCharacter <= "9")
		{
			valSixDigits = valSixDigits + szCharacter;
		}
	}
		
	if(valSixDigits.length != 6)
	{
		return "error";
	}
	else
	{
		valReturn += parseInt(valSixDigits.substring(4,6), 10);
		valReturn += (parseInt(valSixDigits.substring(2,4), 10) * 60);
		valReturn += (parseInt(valSixDigits.substring(0,2), 10) * 3600);
	}
		
	return valReturn;
}

function bytes2String(MBytes)
{
	/*
	float flNum = (float)dwMBytes;
	NumberFormat numFormat = NumberFormat.getNumberInstance();
	numFormat.setMaximumFractionDigits(2);
	String szNum;
	long dwNum = 0;
	szNum = numFormat.format(flNum);
	*/

	var szReturn = "";
	var szNum;

	if(MBytes > (1024 * 1024)) // TB
	{
		szNum = MBytes / 1024 / 1024;

		szReturn = Math.round(szNum) + " TB";
	}
	else if(MBytes > 1024) // GB
	{
		szNum = MBytes / 1024;

		szReturn = Math.round(szNum) + " GB";
	}
	else // MB
	{
		szReturn = MBytes + " MB";
	}
	return szReturn;
}

function trimFrames(szTC)
{
	var szRtn = szTC;
	if(szTC.length > 8)
	{
		szRtn = szTC.substring(3,11);
	}
	return szRtn;
}
/* jshint ignore:start */
const 
/* jshint ignore:end */
	hex0 = [
  0,  16,  32,  48,  64,  80,  96, 112, 128, 144,   0,   0,   0,   0,   0,   0,
  0, 160, 176, 192, 208, 224, 240,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0, 160, 176, 192, 208, 224, 240
];
/* jshint ignore:start */
const 
/* jshint ignore:end */
	hex1 = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   0,   0,   0,   0,   0,   0,
  0,  10,  11,  12,  13,  14,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,  10,  11,  12,  13,  14,  15
];

function parseByte16(str, offset) {
  return hex0[str.charCodeAt(offset) - 48] | hex1[str.charCodeAt(offset + 1) - 48];
}

/* jshint ignore:start */
const 
/* jshint ignore:end */
	uintUp = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'];
/* jshint ignore:start */
const 
/* jshint ignore:end */
	uintLow = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'];

function toString16 (val, uppercase) {
/* jshint ignore:start */  
const 
/* jshint ignore:end */
	first = val >> 4;
/* jshint ignore:start */	
  const 
 /* jshint ignore:end */
	second = val - (first << 4);
  return uppercase ? uintUp[first] + uintUp[second] : uintLow[first] + uintLow[second];
}

// Convert a hex string to a byte array
function hexToBytes(hex) {
	for (var bytes = [], c = 0; c < hex.length; c += 2) {
		//bytes.push(parseInt(hex.substr(c, 2), 16));
		//bytes.push(parseByte16(hex, c));
		// No real difference between these last two
		bytes.push(hex0[hex.charCodeAt(c) - 48] | hex1[hex.charCodeAt(c + 1) - 48]);
		//bytes[c/2] = (hex0[hex.charCodeAt(c) - 48] | hex1[hex.charCodeAt(c + 1) - 48]);
	}
	return bytes;
}

// Convert a byte array to a hex string
function bytesToHex(bytes) {
	for (var hex = [], i = 0; i < bytes.length; i++) {
		hex.push((bytes[i] >>> 4).toString(16));
		hex.push((bytes[i] & 0xF).toString(16));
	}
	return hex.join("");
}

// ******************
// Check for mobile
// ******************
function isItMobile()
{
	// DEBUG - TEST
	//return true;
  if ((navigator.userAgent.indexOf('iPhone') != -1) || 
        (navigator.userAgent.indexOf('iPod') != -1)) {
        <!-- iPhone, iPod -->
	return true;
  } else if ((navigator.userAgent.indexOf('iPad') != -1)) {
        <!-- iPad -->
	return true;
  } else if ((navigator.userAgent.indexOf('Android') != -1)) {
        <!-- Android - need to check screen size for phone vs aPad -->
	return true;
  } else if ((navigator.userAgent.indexOf('Opera Mini') != -1)) {
        <!-- Probably iPhone/Android/NintendoDS -->
	return true;
  } else if ((navigator.userAgent.indexOf('Palm OS') != -1) || 
        (navigator.userAgent.indexOf('PalmOS') != -1) ||
        (navigator.userAgent.indexOf('PalmSource') != -1)) {
        <!-- Palm device -->    
	return true;
  } else if ((navigator.userAgent.indexOf('Mobile') != -1)) {
	return true;
  } else if ((navigator.userAgent.indexOf('320x200') != -1) ||
        (navigator.userAgent.indexOf('240x320') != -1) ||
        (navigator.userAgent.indexOf('320x240') != -1) ||
        (navigator.userAgent.indexOf('160x120') != -1) ||
        (navigator.userAgent.indexOf('640x480') != -1) ||
        (navigator.userAgent.indexOf('360x640') != -1) ||
        (navigator.userAgent.indexOf('640x360') != -1) ||
        (navigator.userAgent.indexOf('640x240') != -1) ||
        (navigator.userAgent.indexOf('320x480') != -1) ||
        (navigator.userAgent.indexOf('480x640') != -1) ||
        (navigator.userAgent.indexOf('320x320') != -1) ||
        (navigator.userAgent.indexOf('160x160') != -1) ||
        (navigator.userAgent.indexOf('176x220') != -1) ||
        (navigator.userAgent.indexOf('160x220') != -1) ||
        (navigator.userAgent.indexOf('120x120') != -1) ||
        (navigator.userAgent.indexOf('120x160') != -1) ||
        (navigator.userAgent.indexOf('584x') != -1) ||
        (navigator.userAgent.indexOf('512x') != -1)) {
	return true;
  } else {
	return false;
  }
  return false;
}
// ******************
// ******************

// ********************
// *** LastChangeMs ***
// ********************

// Check LastChangeMs
function getLastChangeMs() 
{
	// Build the URL to connect to
	var urlLastChangeMs = "VVWGetLastChangeMs?";
	
	// Stop the current request if it's still waiting
	g_xmlHttpMs.abort();

	// Open a connection to the server
	g_xmlHttpMs.open("GET", urlLastChangeMs, true);
    
	// Send the request
	g_xmlHttpMs.send(null);
	
	var newMs = g_xmlHttpMs.responseText;
    
	if(newMs !== "")
	{
	    return newMs;
	}  
	return 0;
}

// A request for LastChangeMs has been received
function updateMs() 
{        
	if (g_xmlHttpMs.readyState == 4) 
	{ 
		// A complete response has been received
		   	  
	}
}

// ****************
// *** Commands ***
// ****************

/** Send Transport Commands
*/
function sendVVWCmd(szCmd) 
{
	// Build the URL to connect to
	//var url = "VVWPassThrough?" + szCmd;
	var url = "VVWXMLMediaCmd?" + szCmd;

	// Open a connection to the server
	g_xmlHttpVvwCmd.open("GET", url);

	// Send the request
	g_xmlHttpVvwCmd.send(null);
}

/** Get current ms
*/
function vvwGetCurMs(lChannel)
{
	// Build the URL to connect to
	var url = "VVWXMLMediaCmd?GetValue&cmdalt=CurrentMs&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url, false);
	// Send the request
	g_xmlHttp.send(null);

    // Pull the response out	
	var xmlObject = g_xmlHttp.responseXML;
	var MediaCmdObject = xmlObject.getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("Position")[0].getAttribute("Value"), 10);
}

/** Send a play
*/
function vvwPlay(lChannel)
{
	// Build the URL to connect to
	var url = "VVWXMLMediaCmd?Play&channel=" + lChannel;

	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Play from position or offset at time
*/
function vvwPlayOffsetAt(lChannel, dwPosition, lOffset, dwMs)
{
    var url;
    if(dwPosition !== -1) {
        url = "VVWXMLMediaCmd?Play&position=" + (dwPosition + lOffset) + "&channel=" + lChannel;
    } else if(lOffset !== 0) {
        url = "VVWXMLMediaCmd?Play&positionoffset=" + lOffset + "&channel=" + lChannel;
    }
    if(dwMs !== -1) {     
        url += "&targetms=" + dwMs + "&channel=" + lChannel;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Play at speed
*/
function vvwPlayAtSpeed(lChannel, lSpeed, dwEnd)
{
    var url = "VVWXMLMediaCmd?Play&speed=" + lSpeed + "&channel=" + lChannel;
    if(dwEnd !== -1 && dwEnd !== 0) {
        url += "&end=" + dwEnd;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Play from to
*/
function vvwPlayFromTo(lChannel, dwFrom, dwTo, fDeferred, fLoop)
{
    var url = "VVWXMLMediaCmd?Play&channel=" + lChannel;
    if(dwFrom != -1) {
        url += "&start=" + dwFrom;
    }
    if(dwTo != -1) {
        url += "&end=" + dwTo;
    }
    if(fDeferred) {
        url += "&deferred";
    }
    if(fLoop) {
        url += "&loop";
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

function vvwLoadClipFromFile(lChannel, sz8CharName, szFileName) 
{                                                                                               
		// Build the URL to connect to
		var urlAddClip = "VVWXMLMediaCmd?Insert&ClipID=" + sz8CharName + "&FileName=" + szFileName + "&channel=" + lChannel; 

		// Open a connection to the server
		g_xmlHttp.open("GET", urlAddClip, false);
	
		g_xmlHttp.setRequestHeader("Content-Type", "text/xml");

		// Send the request
		g_xmlHttp.send(null);
		
}    
   
/** Load clip
*/
function vvwLoadClip(lChannel, sz8CharName, dwStart)
{
    var url = "VVWXMLMediaCmd?Pause&clipid=" + sz8CharName + "&channel=" + lChannel;
    if(dwStart != -1) {
        url += "&start=" + dwStart + "&position=" + dwStart;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Blank (remove) all clips
*/
function vvwBlankAllClips(lChannel)
{
	//cfUseAllIDs | cfUseClipID = 1 << 12 | 1 << 13 = 0x00001000 | 0x00002000 = 12288
    var url = "VVWXMLMediaCmd?Blank&flags=12288&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Blank (remove) clip
*/
function vvwBlankClip(lChannel, sz8CharName)
{
    var url = "VVWXMLMediaCmd?Blank&clipid=" + sz8CharName + "&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Switch clip
*/
function vvwSwitchClip(lChannel, sz8CharName, dwPosition, fUseFrameCount)
{
    var url = "VVWXMLMediaCmd?Switch&clipid=" + sz8CharName + "&channel=" + lChannel;
    if(dwPosition != -1) {
        url += "&start=" + dwPosition + "&position=" + dwPosition;
    }
    if(fUseFrameCount) {
        url += "&framecount";
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** play clip
*/
function vvwPlayClip(lChannel, sz8CharName, fDeferred)
{
    var url = "VVWXMLMediaCmd?Play&clipid=" + sz8CharName + "&channel=" + lChannel;
    if(fDeferred) {
        url += "&deferred";
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Play clip from to
*/
function vvwPlayClipFromTo(lChannel, sz8CharName, dwFrom, dwTo, fDeferred)
{
    var url = "VVWXMLMediaCmd?Play&clipid=" + sz8CharName + "&channel=" + lChannel;
    if(dwFrom != -1) {
        url += "&start=" + dwFrom;
    }
    if(dwTo != -1) {
        url += "&end=" + dwTo;
    }
    if(fDeferred) {
        url += "&deferred";
    }
    if(fDeferred) {
        url += "&deferred";
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Play at ms
*/
function vvwPlayAtMs(lChannel, dwMs)
{
    var url = "VVWXMLMediaCmd?Play&channel=" + lChannel;
    if(dwMs != -1) {
        url += "&targetms=" + dwMs;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Play from to at ms
*/
function vvwPlayFromToAtMs(lChannel, dwMs, dwFrom, dwTo)
{
    var url = "VVWXMLMediaCmd?Play&channel=" + lChannel;
    if(dwFrom != -1) {
        url += "&start=" + dwFrom;
    }
    if(dwTo != -1) {
        url += "&end=" + dwTo;
    }
    if(dwMs != -1) {
        url += "&targetms=" + dwMs;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Record at ms
*/
function vvwRecordAtMs(lChannel, dwMs, dwFrom, dwTo)
{
    var url = "VVWXMLMediaCmd?Record&channel=" + lChannel;
    if(dwMs != -1) {
        url += "&targetms=" + dwMs;
    }
    if(dwFrom != -1) {
        url += "&start=" + dwFrom;
    }
    if(dwTo != -1) {
        url += "&end=" + dwTo;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Fast forward
*/
function vvwFastForward(lChannel)
{
    var url = "VVWXMLMediaCmd?Play&speed=" + 655200 + "&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Fast reverse
*/
function vvwFastReverse(lChannel)
{
    var url = "VVWXMLMediaCmd?Play&speed=" + -655200 + "&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Pause
*/
function vvwPause(lChannel)
{
    var url = "VVWXMLMediaCmd?Pause&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Send Seek
*/
function vvwSeek(lChannel, szPos) 
{
	// Build the URL to connect to
	var url = "VVWXMLMediaCmd?Pause&channel=" + lChannel + "&position=" + szPos;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Send Seek relative
*/
function vvwSeekRelative(lChannel, lFrameOffset) 
{
	// Build the URL to connect to
	var url = "VVWXMLMediaCmd?Pause&channel=" + lChannel + "&positionoffset=" + lFrameOffset;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Stop
*/
function vvwStop(lChannel)
{
    var url = "VVWXMLMediaCmd?Stop&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Record
*/
function vvwRecord(lChannel)
{
    var url = "VVWXMLMediaCmd?Record&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Record from to
*/
function vvwRecordFromTo(lChannel, dwFrom, dwTo)
{
    var url = "VVWXMLMediaCmd?Record&channel=" + lChannel;
    if(dwFrom != -1) {
        url += "&start=" + dwFrom;
    }
    if(dwTo != -1) {
        url += "&end=" + dwTo;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Record Stop
*/
function vvwRecordStop(lChannel, sz8CharClipName, dwDuration)
{
    var url = "VVWXMLMediaCmd?RecStop&channel=" + lChannel + "&clipid=" + sz8CharClipName;
    if(dwDuration !== -1 && dwDuration !== 0) {
        url += "&end=" + dwDuration;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Record Stop
*/
function vvwRecordStopFileName(lChannel, sz8CharClipName, szFileName, dwDuration)
{
    var url = "VVWXMLMediaCmd?RecStop&channel=" + lChannel + "&clipid=" + sz8CharClipName + "&filename=" + szFileName;
    if(dwDuration !== -1 && dwDuration !== 0) {
        url += "&end=" + dwDuration;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

/** Set record presets
*/
function vvwRecordPresets(lChannel, lVidEdit, lAudEdit, lInfEdit)
{
    var url = "VVWXMLMediaCmd?ChanSelect&channel=" + lChannel + "&videochannels=" + lVidEdit + "&audiochannels=" + lAudEdit + "&infochannels=" + lInfEdit;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

//vvwCleanRecordWipeDrive

/** Eject
*/
function vvwEject(lChannel)
{
    var url = "VVWXMLMediaCmd?Eject&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

// vvwTransfer

/** vvwUpdateStatus
*/
function vvwUpdateStatus(lChannel)
{
	// Build the URL to connect to
	var url = "VVWXMLMediaCmd?GetState&channel=" + lChannel;
	// Open a connection to the server
	g_xmlHttp.open("GET", url, false);
	// Send the request
	g_xmlHttp.send(null);

    // Pull the response out	
	g_xmlStateObject[lChannel] = g_xmlHttp.responseXML;
}

/** vvwGetState
*/
function vvwGetState(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("Cmd")[0].getAttribute("Value"), 10);
}

/** vvwGetFlags
*/
function vvwGetFlags(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	if(MediaCmdObject[0].getElementsByTagName("Flags")[0]) {
	    return parseInt(MediaCmdObject[0].getElementsByTagName("Flags")[0].getAttribute("Value"), 10);
	} 
	return 0;
}

/** vvwGetSpeed
*/
function vvwGetSpeed(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("Speed")[0].getAttribute("Value"), 10);
}

/** vvwGetPosition
*/
function vvwGetPosition(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("Position")[0].getAttribute("Value"), 10);
}

/** vvwGetLastMs
*/
function vvwGetLastMs(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("CmdAlt")[0].getAttribute("Value"), 10);
}

/** vvwGetStart
*/
function vvwGetStart(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("Start")[0].getAttribute("Value"), 10);
}

/** vvwGetEnd
*/
function vvwGetEnd(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return parseInt(MediaCmdObject[0].getElementsByTagName("End")[0].getAttribute("Value"), 10);
}

/** vvwGetClipName
*/
function vvwGetClipName(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return getInnerText(MediaCmdObject[0].getElementsByTagName("ClipID")[0]);
}

/** vvwGetFileName
*/
function vvwGetFileName(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return getInnerText(MediaCmdObject[0].getElementsByTagName("FileName")[0]);
}

/** vvwGetCurTC
*/
function vvwGetCurTC(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return getInnerText(MediaCmdObject[0].getElementsByTagName("Position")[0]);
}

/** vvwGetCurState
*/
function vvwGetCurState(lChannel) 
{
    // vvwUpdateStatus(lChannel);
	var MediaCmdObject = g_xmlStateObject[lChannel].getElementsByTagName("MediaCmd");
	return getInnerText(MediaCmdObject[0].getElementsByTagName("Cmd")[0]);
}

//vvwGetNextClip

//vvwGetChannelName gsVVWChannelName
function vvwSetMetaData(vvwChannel, sz8CharClipName, vvwiInfoRequest, nValue, szValue)
{
    var url = "VVWXMLMediaCmd?SetValue&cmdalt=metadata&UsingCurrent&channel=" + vvwChannel + "&position=" + vvwiInfoRequest;
        
    if(sz8CharClipName !== "") {
        url += "&clipid=" + sz8CharClipName;
    }
    if(nValue != -1) {
        url += "&start=" + nValue;
    }
    if(szValue !== null) {
        url += "&filename=" + szValue;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}

function vvwGetMetaData(vvwChannel, sz8CharClipName, vvwiInfoRequest)
{
    var url = "VVWXMLMediaCmd?GetValue&cmdalt=metadata&UsingCurrent&channel=" + vvwChannel + "&position=" + vvwiInfoRequest;
    if(sz8CharClipName !== "") {
        url += "&clipid=" + sz8CharClipName;
    }
	// Open a connection to the server
	g_xmlHttp.open("GET", url, false);
	// Send the request
	g_xmlHttp.send(null);
	var xmlObject = g_xmlHttp.responseXML;
	var MediaCmdObject = xmlObject.getElementsByTagName("MediaCmd");
	var txt = "";
	if(vvwiInfoRequest < vvwiNumericStart) {
	    // Return string
	    txt = getInnerText(MediaCmdObject[0].getElementsByTagName("FileName")[0]);
	    if(txt === null) {
	        txt = "";
	    }
	    return txt;
	}
	// Return start
	return parseInt(MediaCmdObject[0].getElementsByTagName("Start")[0].getAttribute("Value"), 10);
}

// Type 0 = file, 3 = user, 4 = system
function vvwSaveMetaData(vvwChannel, saveType)
{
    var url = "VVWXMLMediaCmd?SetValue&UsingCurrent&channel=" + vvwChannel + "&cmdalt=MetaDataReadWrite&position=" + saveType;
	// Open a connection to the server
	g_xmlHttp.open("GET", url);
	// Send the request
	g_xmlHttp.send(null);
}
